const jwt = require('jsonwebtoken')
const User = require('../Model').Users
const Admin = require('../Model').Admins

exports.AdminRoute = async (req, res, next) => {
    try {
        const TokenHeaders = req.headers['authorization']
        if (!TokenHeaders || !TokenHeaders.startsWith('Bearer')) return res.status(403).send(`Forbidden: Access Denied`)
        const token = TokenHeaders.split(' ')[1]
        const verified = jwt.decode(token, process.env.JWT_SECRET)
        if (!verified) return res.json({ status: 403, msg: 'your session has expired or does not exist' })
        if (verified.role !== 'admin') return res.json({ status: 400, msg: 'your account is not authorized for this request' })

        const checkAdmin = await Admin.findOne({ where: { id: verified.id } })
        if (!checkAdmin) return res.json({ status: 400, msg: 'account session expired' })

        req.admin = verified.id
        next()
    } catch (error) {
        return res.json({ status: 400, msg: `error ${error}` })
    }
}


exports.UserRoute = async (req, res, next) => {
    try {
        const TokenHeaders = req.headers['authorization']
        if (!TokenHeaders || !TokenHeaders.startsWith('Bearer')) return res.status(403).send(`Forbidden: Access Denied`)
        const token = TokenHeaders.split(' ')[1]
        const verified = jwt.decode(token, process.env.JWT_SECRET)
        if (!verified) return res.json({ status: 403, msg: 'your session has expired or does not exist' })
        if (verified.role !== 'user') return res.json({ status: 400, msg: 'your account is not authorized for this request' })

        const checkUser = await User.findOne({ where: { id: verified.id } })
        if (!checkUser) return res.json({ status: 400, msg: 'account session expired' })

        req.user = verified.id
        next()
    } catch (error) {
        return res.json({ status: 400, msg: `error ${error}` })
    }
}